<?php

namespace QuadLayers\QLWAPP_PRO;

use QuadLayers\QLWAPP\Models\Settings;
use QuadLayers\QLWAPP\Models\Box;
use QuadLayers\QLWAPP\Models\Contact;
use QuadLayers\QLWAPP\Models\Button;
use QuadLayers\QLWAPP\Models\Display;
use QuadLayers\QLWAPP\Controllers\Display_Services;

class Frontend {

	protected static $instance;

	private function __construct() {
		add_action( 'qlwapp_load', array( $this, 'load' ) );
	}

	public function add_js() {

		wp_enqueue_style( 'qlwapp-icons', plugins_url( '/assets/qlwapp-icons.min.css', QLWAPP_PRO_PLUGIN_FILE ), null, QLWAPP_PRO_PLUGIN_VERSION, 'all' );

		$settings_model = new Settings();
		$settings       = $settings_model->get();

		if ( empty( $settings['googleAnalytics'] ) || $settings['googleAnalytics'] == 'disable' ) {
			return;
		}

		$ga_key      = $settings['googleAnalytics'] == 'v3' ? trim( $settings['googleAnalyticsV3Id'] ) : trim( $settings['googleAnalyticsV4Id'] );
		$ga_category = $settings['googleAnalyticsCategory'] ? trim( $settings['googleAnalyticsCategory'] ) : 'Quadlayers Social Chat';
		$ga_label    = $settings['googleAnalyticsLabel'] ? trim( $settings['googleAnalyticsLabel'] ) : 'Quadlayers Social Chat';

		if ( 'yes' === $settings['googleAnalyticsScript'] ) {
			wp_enqueue_script( 'qlwapp-analytics', sprintf( 'https://www.googletagmanager.com/gtag/js?id=%s', esc_attr( $ga_key ) ), array(), null );
		} else {
			wp_register_script( 'qlwapp-analytics', '', array(), '', true );
			wp_enqueue_script( 'qlwapp-analytics' );
		}
		wp_add_inline_script(
			'qlwapp-analytics',
			sprintf(
				'( function() {
						window.dataLayer = window.dataLayer || [];

						function gtag() {
							dataLayer.push(arguments);
						}
	
						gtag("js", new Date());
						gtag("config", "%1$s");
	
						function ga_events(events) {
	
							const {
								ga_action,
								ga_category,
								ga_label,
							} = events;
	
							if (typeof gtag !== "undefined") {
								gtag("event", ga_action, {
									"event_category": ga_category,
									"event_label": ga_label,
								});
							} else 
							if (typeof ga !== "undefined" && typeof ga.getAll !== "undefined") {
								var tracker = ga.getAll();
								tracker[0].send("event", ga_category, ga_action, ga_label);
							} else 
							if (typeof __gaTracker !== "undefined") {
								__gaTracker("send", "event", ga_category, ga_action, ga_label);
							}
	
							if (typeof dataLayer !== "undefined") {
								dataLayer.push({
									"event": ga_action,
									"event_action": ga_action,
									"event_category": ga_category,
									"event_label": ga_label,
								});
							}
						}
	
						window.addEventListener("qlwapp.click", function() {
							ga_events({
								ga_action: "click:quadlayers_social_chat",
								ga_category: "%2$s",
								ga_label: "%3$s",
							});
						});
					} ) ();',
				$ga_key,
				$ga_category,
				$ga_label
			)
		);
	}

	public function box_premium( $template ) {

		$box_model       = new Box();
		$contact_model   = new Contact();
		$button_model    = new Button();
		$display_model   = new Display();
		$display_service = new Display_Services();
		$contacts        = $contact_model->get_contacts_reorder();
		$display         = $display_model->get();
		$button          = $button_model->get();
		$box             = $box_model->get();
		$template        = QLWAPP_PRO_PLUGIN_DIR . 'templates/box_premium.php';
		return $template;
	}

	public function load() {
		add_action( 'wp_enqueue_scripts', array( $this, 'add_js' ) );
		add_filter( 'qlwapp_box_template', array( $this, 'box_premium' ) );
	}

	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
}
