export const isNull = (input) => input === null;
export const isUndefined = (input) => typeof input === 'undefined';
export const isNullOrUndefined = (input) => isNull(input) || isUndefined(input);
export const getConstructor = (input) => (!isNullOrUndefined(input) ? input.constructor : undefined);
export const isObject = (input) => getConstructor(input) === Object;
export const isNumber = (input) => getConstructor(input) === Number && !Number.isNaN(input);
export const isString = (input) => getConstructor(input) === String;
export const isBoolean = (input) => getConstructor(input) === Boolean;
export const isFunction = (input) => getConstructor(input) === Function;
export const isArray = (input) => Array.isArray(input);
export const isInstanceOf = (input, constructor) => Boolean(input && constructor && input instanceof constructor);
export const isPrototypeOf = (input, object) => Boolean(input && object && Object.isPrototypeOf.call(object.prototype, input));
