<?php
   /*
   Plugin Name: KPS Plugins (utilidades)
   Plugin URI: https://www.kingperu.com
   description: Plugin para agregar complementos a WordPress etiquetas en la zona header
   Version: 1.0
   Author: Libio Balbin
   Text Domain: KP SERVER GROUP
   Author URI: https://www.kpserver.net
   License: GPL
   */
 // require(plugin_dir_url( __FILE__ ). 'funciones/kps-header-footer.php');
if ( class_exists( 'WooCommerce' ) ) {
    include_once('funciones/kps-woocommerce.php');
	} else {
    // you don't appear to have WooCommerce activated
}
function checkWoocommerce () {
   if ( class_exists( 'WooCommerce' ) ) {
        $estadoWoocommerce = 'En horabuena, tiene instalado Woocommerce y puede usar los complementos';
    } else {
        $estadoWoocommerce = 'No ha instalado Woocommerce';
    }
    return $estadoWoocommerce;
}
function agregar_estilos_jscripts() {
    $plugin_url = plugin_dir_url( __FILE__ );
    wp_enqueue_style( 'style1', $plugin_url . 'kpswoo-funciones.css' );
    wp_enqueue_script( 'jquery', '', '', '', true );
    wp_enqueue_script( 'includes', $plugin_url . 'kpswoo-funciones.js', array( 'jquery' ), '', true );
}
add_action( 'wp_enqueue_scripts', 'agregar_estilos_jscripts' );//anade nuestros jscript y css a la pagina

function kps_admin_style() {
    $plugin_url = plugin_dir_url( __FILE__ );
    wp_enqueue_style('admin-styles', $plugin_url.'css/columnas.css');
}
add_action('admin_enqueue_scripts', 'kps_admin_style');

function kpswoo_configuracion($links) { 
  $settings_link = '<a href="admin.php?page=kps-utilidades">Configurar</a>'; 
  array_unshift($links, $settings_link); 
  return $links; 
}
$plugin = plugin_basename(__FILE__); 
add_filter("plugin_action_links_$plugin", 'kpswoo_configuracion' );
function kpswoo_admin(){
add_menu_page('Administrador', 'KPS Utilidades', 'manage_options', 'kps-utilidades', 'kpswoo_utilidades','dashicons-cloud' );
add_submenu_page( 'kps-utilidades', 'kps-categorias', 'Categorias', 'manage_options', 'kps-categorias', 'kpswoo_categorias');
add_submenu_page( 'kps-utilidades', 'kps-productos', 'Productos', 'manage_options', 'kps-productos', 'kpswoo_productos');
}
add_action('admin_menu', 'kpswoo_admin');
function kpswoo_utilidades(){
        echo '<div class="welcome-panel"><div class="welcome-panel-content">
        <h1>KPS Utilidades WordPress</h1>
        <p>KP SERVER SAC es una empresa en Per&uacute; que dise&ntilde;a y da alojamiento Web en la nube, inicia operaciones el a&ntilde;o 2003.</p>';
		echo '<hr />';
		echo checkWoocommerce ();
		echo '<div class="welcome-panel-column-container">
		    <div class="col-3">
		    <img src="'.plugin_dir_url(__FILE__).'/imagenes/wordpress-plugins-icono.webp" border="0">
		    </div>
		    <div class="col-9">
		        <p>Hemos construido funciones complementarias para proyectos de WordPress, adicionando funciones particulares para mejorar el funcionamiento y compatibilidad con algunos constructores como Oxygen Builder. Elija el complemento que necesita para su proyecto.</p>
		        <h2>Woocommerce - Tabs</h2>
				Si su proyecto tiene instalado Woocommerce, podra usar el complemento para adicionar tabs en los detalles del producto
				<h2>Favicon</h2>
				Algunos complementos o constructores bloquean el editor por defecto wordpress sin poder adicionar un icono a su Web, con esta funcionalidad podr&aacute; elegir una imagen.
		    </div>
		</div>
			
	</div></div>';
}
function kpswoo_categorias(){
        echo '<div class="wrap"><div id="icon-options-general" class="icon32"><br></div>
        <h2>KPSWOO - Categorias</h2></div>';
		echo '<hr />';
		echo 'Ingrese el ShortCode para su uso:
				<code>
					[kpswoo-categoria-listado]
				</code>';
}
function kpswoo_productos(){
        echo '<div class="wrap"><div id="icon-options-general" class="icon32"><br></div>
        <h2>KPSWOO - Productos</h2></div>';
		echo '<hr />';
		echo 'Ingrese el ShortCode para su uso:
				<code>
					[kpswoo-productos-vistos]
				</code>';
}

function kps_code_analytics() {
$varTEXT = <<<HTML
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-11N8P3VMY1"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-11N8P3VMY1');
    </script>

	<!-- Global site tag (gtag.js) - Google Ads: 10973968620 --> 
	<script async src="https://www.googletagmanager.com/gtag/js?id=AW-10973968620"></script> 
	<script> 
		window.dataLayer = window.dataLayer || []; 
		function gtag(){dataLayer.push(arguments);} 
		gtag('js', new Date()); 
		gtag('config', 'AW-10973968620'); 
	</script> 

	<!-- Event snippet for Website lead conversion page --> 
	<script> 
		gtag('event', 'conversion', {'send_to': 'AW-10973968620/WH4rCJ2R4dgDEOzx5fAo'}); 
	</script> 
HTML;
    echo $varTEXT;
    }
add_action('wp_head', 'kps_code_analytics', 1);
function kps_agregar_favicon() { 
	echo '<link rel="shortcut icon" type="image/x-icon" href="'.wp_get_attachment_url( get_option( 'media_selector_attachment_id' ) ).'" />' . "\n";
	//echo '<link rel="shortcut icon" type="image/x-icon" href="'.get_site_url().'/wp-content/uploads/2022/09/isotipo-tecnihogar-min.png" />' . "\n";
    } 
add_action('wp_head', 'kps_agregar_favicon', 2);
// administrar favicon
add_action( 'admin_menu', 'register_media_selector_settings_page' );

function register_media_selector_settings_page() {
	//add_submenu_page( 'options-general.php', 'Media Selector', 'KPS Administracion', 'manage_options', 'media-selector', 'media_selector_settings_page_callback' );
	add_submenu_page( 'kps-utilidades', 'Elegir Favicon al Website', 'Favicon', 'manage_options', 'kps-favicon', 'media_selector_settings_page_callback');
	add_submenu_page( 'kps-utilidades', 'Codigo en Header y Footer', 'Header/Footer', 'manage_options', 'kps-script', 'script_selector_settings_page_callback');
}
function media_selector_settings_page_callback() {
	// Save attachment ID
	if ( isset( $_POST['submit_image_selector'] ) && isset( $_POST['image_attachment_id'] ) ) :
		update_option( 'media_selector_attachment_id', absint( $_POST['image_attachment_id'] ) );
	endif;
	wp_enqueue_media();
	?><form method='post'>
	    <h1>Elegir un icono para la Web</h1>
		<p>Algunos temas bloquean o anulan la personalizacion de la apariencia, impidiendo asignar un icono al sitio Web, con esta utilidad podra elegir una imagen desde la biblioteca. </p>
		<img src="<?=plugin_dir_url(__FILE__);?>imagenes/muestra-favicon.gif" border="0">
		<div class='image-preview-wrapper'>
			<img id='image-preview' src='<?php echo wp_get_attachment_url( get_option( 'media_selector_attachment_id' ) ); ?>' height='100'>
		</div>
		<input id="upload_image_button" type="button" class="button" value="<?php _e( 'Elegir un icono' ); ?>" />
		<input type='hidden' name='image_attachment_id' id='image_attachment_id' value='<?php echo get_option( 'media_selector_attachment_id' ); ?>'>
		<input type="submit" name="submit_image_selector" value="Guardar" class="button-primary">
	</form><?php
}
function script_selector_settings_page_callback() {
	// Save attachment ID
	if ( isset( $_POST['kps_submit_scripts'] ) ) :
		update_option( 'media_selector_attachment_id', absint( $_POST['image_attachment_id'] ) );
	endif;
	wp_enqueue_media();
	?>
	<div class="welcome-panel">
		<div class="welcome-panel-content">
			<form method='post'>
			<h1>Gestionar Scripts de Cabecera / Footer</h1>
			<p>Esta utilidad le permitir&aacute; insertar c&oacute;digo extra en la cabecera/pie de su proyecto WordPress. Ideal para insertar etiquetas Analytics/Adwords y otras funciones que requiera de javascript. </p>
			<div class="welcome-panel-column-container">
				<div class="col-md-4">
					<h2>Funciones comunes para el uso de etiquetas</h2>
					<ul>
						<li>Insertar un código de seguimiento de una campaña de Adwords.</li>
						<li>Insertar código de seguimiento para Google Analytics.</li>
						<li>Añadir código de validación de dominio de MailChimp, Acumbamail, Mailrelay, etc.</li>
						<li>Añadir código de validación de dominio de Google Analytics.</li>
						<li>Añadir CSS personalizado en cabecera o pies de página.</li>
						<li>Insertar el código de Facebook Pixel.</li>
						<li>Añadir código HTML o JavaScript.</li>
						<li>Y un largo etcétera…</li>
					</ul>
				</div>
				<div class="col-md-8">
					<div class="">
						Agregar scritps en zona Header
						<textarea name="txt-script-header" style="width:100%; height: 100px;" placeholder="Pegar el codigos javascripts que se imprimira en la zona de cabecera <META de la pagina <script>/*insertar codigo*/</script>"></textarea>
					</div>
					<div class="">
						Agregar scritps en zona Footer
						<textarea name="txt-script-footer" style="width:100%; height: 100px;" placeholder="Pegar el codigos javascripts que se imprimira al pie de la pagina (footer) <script>/*insertar codigo*/</script>"></textarea>
					</div>
				</div>
			</div>
			<input type="submit" name="kps_submit_scripts" value="Guardar Scripts" class="button-primary">
		</div>
	</form>
</div></div>
	<?php
}
add_action( 'admin_footer', 'media_selector_print_scripts' );
function media_selector_print_scripts() {

	$my_saved_attachment_post_id = get_option( 'media_selector_attachment_id', 0 );

	?><script type='text/javascript'>

		jQuery( document ).ready( function( $ ) {

			// Uploading files
			var file_frame;
			var wp_media_post_id = wp.media.model.settings.post.id; // Store the old id
			var set_to_post_id = <?php echo $my_saved_attachment_post_id; ?>; // Set this

			jQuery('#upload_image_button').on('click', function( event ){

				event.preventDefault();

				// If the media frame already exists, reopen it.
				if ( file_frame ) {
					// Set the post ID to what we want
					file_frame.uploader.uploader.param( 'post_id', set_to_post_id );
					// Open frame
					file_frame.open();
					return;
				} else {
					// Set the wp.media post id so the uploader grabs the ID we want when initialised
					wp.media.model.settings.post.id = set_to_post_id;
				}

				// Create the media frame.
				file_frame = wp.media.frames.file_frame = wp.media({
					title: 'Select a image to upload',
					button: {
						text: 'Use this image',
					},
					multiple: false	// Set to true to allow multiple files to be selected
				});

				// When an image is selected, run a callback.
				file_frame.on( 'select', function() {
					// We set multiple to false so only get one image from the uploader
					attachment = file_frame.state().get('selection').first().toJSON();

					// Do something with attachment.id and/or attachment.url here
					$( '#image-preview' ).attr( 'src', attachment.url ).css( 'width', 'auto' );
					$( '#image_attachment_id' ).val( attachment.id );

					// Restore the main post ID
					wp.media.model.settings.post.id = wp_media_post_id;
				});

					// Finally, open the modal
					file_frame.open();
			});

			// Restore the main ID when the add media button is pressed
			jQuery( 'a.add_media' ).on( 'click', function() {
				wp.media.model.settings.post.id = wp_media_post_id;
			});
		});

	</script><?php

}
?>