<?php
//dimension de las imagenes en las categorias
function size_of_category_thumb($u)
{
    return array(600, 450,true);
}
add_filter('subcategory_archive_thumbnail_size', 'size_of_category_thumb');

function kpswoo_list_categories( $args = '' ) {

    $defaults = array(
        'child_of'            => 0,
        'current_category'    => 0,
        'depth'               => 0,
        'echo'                => 1,
        'exclude'             => '',
        'exclude_tree'        => '',
        'feed'                => '',
        'feed_image'          => '',
        'feed_type'           => '',
        'hide_empty'          => 0,
        'hide_title_if_empty' => false,
        'hierarchical'        => true,
        'order'               => 'ASC',
        'orderby'             => 'name',
        'separator'           => '<br />',
        'show_count'          => 0,
        'show_option_all'     => '',
        'show_option_none'    => __( 'No categories' ),
        'style'               => 'list',
        'taxonomy'            => 'product_cat',
        'title_li'            => __( 'Categorias' ),
        'use_desc_for_title'  => 1,
    );
 
    $parsed_args = wp_parse_args( $args, $defaults );
 
    if ( ! isset( $parsed_args['pad_counts'] ) && $parsed_args['show_count'] && $parsed_args['hierarchical'] ) {
        $parsed_args['pad_counts'] = true;
    }
 
    // Descendants of exclusions should be excluded too.
    if ( true == $parsed_args['hierarchical'] ) {
        $exclude_tree = array();
 
        if ( $parsed_args['exclude_tree'] ) {
            $exclude_tree = array_merge( $exclude_tree, wp_parse_id_list( $parsed_args['exclude_tree'] ) );
        }
 
        if ( $parsed_args['exclude'] ) {
            $exclude_tree = array_merge( $exclude_tree, wp_parse_id_list( $parsed_args['exclude'] ) );
        }
 
        $parsed_args['exclude_tree'] = $exclude_tree;
        $parsed_args['exclude']      = '';
    }
 
    if ( ! isset( $parsed_args['class'] ) ) {
        $parsed_args['class'] = ( 'category' === $parsed_args['taxonomy'] ) ? 'categories' : $parsed_args['taxonomy'];
    }
 
    if ( ! taxonomy_exists( $parsed_args['taxonomy'] ) ) {
        return false;
    }
 
    $show_option_all  = $parsed_args['show_option_all'];
    $show_option_none = $parsed_args['show_option_none'];
    $categories = get_categories( $parsed_args );
 
    $output = '<div class="nav">';
    $output .= '<button type="button" class="hamburguer"></button><h3>Categorias</h3>';
    $output .= '<ul class="menu">';
    if ( empty( $categories ) ) {
        if ( ! empty( $show_option_none ) ) {
            if ( 'list' === $parsed_args['style'] ) {
                $output .= '<li class="cat-item-none">' . $show_option_none . '</li>';
            } else {
                $output .= $show_option_none;
            }
        }
    } else {
        if ( ! empty( $show_option_all ) ) {
 
            $posts_page = '';
 
            // For taxonomies that belong only to custom post types, point to a valid archive.
            $taxonomy_object = get_taxonomy( $parsed_args['taxonomy'] );
            if ( ! in_array( 'post', $taxonomy_object->object_type, true ) && ! in_array( 'page', $taxonomy_object->object_type, true ) ) {
                foreach ( $taxonomy_object->object_type as $object_type ) {
                    $_object_type = get_post_type_object( $object_type );
 
                    // Grab the first one.
                    if ( ! empty( $_object_type->has_archive ) ) {
                        $posts_page = get_post_type_archive_link( $object_type );
                        break;
                    }
                }
            }
 
            // Fallback for the 'All' link is the posts page.
            if ( ! $posts_page ) {
                if ( 'page' === get_option( 'show_on_front' ) && get_option( 'page_for_posts' ) ) {
                    $posts_page = get_permalink( get_option( 'page_for_posts' ) );
                } else {
                    $posts_page = home_url( '/' );
                }
            }
 
            $posts_page = esc_url( $posts_page );
            if ( 'list' === $parsed_args['style'] ) {
                $output .= "<li class='cat-item-all'><a href='$posts_page'>$show_option_all</a></li>";
            } else {
                $output .= "<a href='$posts_page'>$show_option_all</a>";
            }
        }
 
        if ( empty( $parsed_args['current_category'] ) && ( is_category() || is_tax() || is_tag() ) ) {
            $current_term_object = get_queried_object();
            if ( $current_term_object && $parsed_args['taxonomy'] === $current_term_object->taxonomy ) {
                $parsed_args['current_category'] = get_queried_object_id();
            }
        }
 
        if ( $parsed_args['hierarchical'] ) {
            $depth = $parsed_args['depth'];
        } else {
            $depth = -1; // Flat.
        }
        $output .= walk_category_tree( $categories, $depth, $parsed_args );
    }
 
    if ( $parsed_args['title_li'] && 'list' === $parsed_args['style']
        && ( ! empty( $categories ) || ! $parsed_args['hide_title_if_empty'] )
    ) {
        $output .= '</ul></li>';
    }
    $output .= '</div>';
 return $output;
}
add_shortcode('kpswoo-categoria-listado', 'kpswoo_list_categories');
//categorias principales con imagenes
function kpswoo_categorias_imagenes() {
	$taxonomy     = 'product_cat';//Woocommerce taxanomy name
	$orderby      = 'name';  
	$show_count   = 1;      //set 1 for yes, 0 for no
	$pad_counts   = 0;      //set 1 for yes, 0 for no
	$hierarchical = 1;      //set 1 for yes, 0 for no  
	$title        = '';  
	$empty        = 0;
	$args = array(
		'taxonomy'     => $taxonomy,
		'orderby'      => $orderby,
		'show_count'   => $show_count,
		'pad_counts'   => $pad_counts,
		'hierarchical' => $hierarchical,
		'title_li'     => $title,
		'hide_empty'   => $empty
	);
	$output .= '<div class="kps-woocommerce">';
	$output .= '	<ul class="products">';  
	$get_all_categories = get_categories( $args );
	foreach ($get_all_categories as $cat)
		{
		if($cat->category_parent == 0)
			{
			$category_id = $cat->term_id; 
			$thumbnail_id = get_woocommerce_term_meta( $cat->term_id, 'thumbnail_id', true );
			$image = wp_get_attachment_url( $thumbnail_id );
			$output .= '		<li class="product">';
			$output .= '			<a href="'. get_term_link($cat->slug, 'product_cat') .'">';
			if ( $image )
				{ $output .= '			<img src="' . $image . '" alt="'.$cat->name.'" />'; }
			else
				{ $output .= '			<img src="'.plugin_dir_url(__FILE__).'imagen-vacia.jpg" />'; }
			$output .= '			'.$cat->name;
			$output .= '			</a>';
			$output .= '			('.$cat->count.')';
			$output .= '		</li>';
			}
		}
	$output .= '	</ul>';
	$output .= '</div>';
	return $output;
}
add_shortcode('kpswoo-categorias-imagenes', 'kpswoo_categorias_imagenes');



function kpswoo_productos_vistos( $atts, $output = null )
	{
	// Get shortcode parameters
	extract(shortcode_atts(array(
		"per_page" => '5'
	), $atts));
	// Get WooCommerce Global
	global $woocommerce;
	// Create the object
	ob_start();
	// Get products per page
	if( !isset( $per_page ) ? $number = 10 : $number = $per_page )
	// Create query arguments array
	$query_args = array(
		'posts_per_page' => $number,
		'no_found_rows'  => 1,
		'post_status'    => 'publish',
		'post_type'      => 'product',
		'post__in'       => $viewed_products,
		'orderby'        => 'rand'
		);
	// Add meta_query to query args
	$query_args['meta_query'] = array();
	// Check products stock status
	$query_args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
	// Create a new query
	$r = new WP_Query($query_args);
	$output .= '<div class="swiper-container swiper-full-mobile swiper-container-initialized swiper-container-horizontal">';
	//$output .= '		<div class="content">';
	// If query return results
	if ( $r->have_posts() ) {
		$output .= '<div class="swiper-wrapper" >';
		// Start the loop
		while ( $r->have_posts()) {
			$r->the_post();
			global $product;
			$output .= '<div class="swiper-slide"><a href="'.get_permalink().'">'.( has_post_thumbnail() ? get_the_post_thumbnail( $r->post->ID,'medium_large') : woocommerce_placeholder_img('medium_large')).'<br />'.get_the_title().'</a>'.$product->get_price_html().'</div>';
			}
		$output .= '</div>';
		}
	// Get clean object
	$output .= ob_get_clean();
	// Return whole content
	//$output .= '	</div>';
	$output .= '</div>';
	return $output;
	}
// Register the shortcode
add_shortcode("kpswoo-productos-vistos", "kpswoo_productos_vistos");



/* AGREGAR TABS WOOCOMMERCE */

   /*** funcion para adicionar en woocommerce tabs en los detalles de productos */
   function custom_tab_options_tab()
      {
?>
         <li class="custom_tab"><a href="#custom_tab_data"><span><?php _e('Tabs Adicionales (KPS)', 'woothemes');?></span></a></li>
<?php }
   add_action('woocommerce_product_write_panel_tabs', 'custom_tab_options_tab');
   /*** En la siguente funcion se puede adicionar como restar tabs, si no tiene contenido no se muestra */
   function custom_tab_options()
      {
      global $post;
      $custom_tab_options = array('content1' => get_post_meta($post->ID, 'custom_tab_content1', true), 'content2' => get_post_meta($post->ID, 'custom_tab_content2', true), 'content3' => get_post_meta($post->ID, 'custom_tab_content3', true));
?>
      <div id="custom_tab_data" class="panel woocommerce_options_panel">
         <div class="options_group custom_tab_options">
            <h2 class="form-field"><?php _e('Caracter&iacute;sticas:', 'woothemes');?></h2>
<?php 
   wp_editor($custom_tab_options['content1'], 'custom_tab_content1', array('textarea_name' => 'custom_tab_content1', 'media_buttons' => false, 'textarea_rows' => 5, 'teeny' => true));
?>
            <h2 class="form-field"><?php _e('Ventajas:', 'woothemes');?></h2>
<?php
   wp_editor($custom_tab_options['content2'], 'custom_tab_content2', array('textarea_name' => 'custom_tab_content2', 'media_buttons' => false, 'textarea_rows' => 5, 'teeny' => true));
?>
            <h2 class="form-field"><?php _e('Otros:', 'woothemes');?></h2>
<?php 
   wp_editor($custom_tab_options['content3'], 'custom_tab_content3', array('textarea_name' => 'custom_tab_content3', 'media_buttons' => false, 'textarea_rows' => 5, 'teeny' => true));
?>
         </div>
      </div>
<?php 
      }
      add_action('woocommerce_product_write_panels', 'custom_tab_options');
      /*** Process meta * * Processes the custom tab options when a post is saved */
      function process_product_meta_custom_tab($post_id)
         {
         update_post_meta($post_id, 'custom_tab_content1', $_POST['custom_tab_content1']);
         update_post_meta($post_id, 'custom_tab_content2', $_POST['custom_tab_content2']);
         update_post_meta($post_id, 'custom_tab_content3', $_POST['custom_tab_content3']);
         }
      add_action('woocommerce_process_product_meta', 'process_product_meta_custom_tab');
      /** Add extra tabs to front end product page **/
      if (!function_exists('woocommerce_product_custom_tab')) 
         {
         function woocommerce_product_custom_tab($tabs)
            {
            global $post;
            $custom_tab_options = array('content1' => get_post_meta($post->ID, 'custom_tab_content1', true), 'content2' => get_post_meta($post->ID, 'custom_tab_content2', true), 'content3' => get_post_meta($post->ID, 'custom_tab_content3', true));
            if ($custom_tab_options['content1'] != '') {
               $tabs[] = array('title' => 'Caracter&iacute;sticas', 'callback' => custom_product_tab_panel_1, 'priority' => 11);
               }
            if ($custom_tab_options['content2'] != '') {
               $tabs[] = array('title' => 'Ventajas', 'callback' => custom_product_tab_panel_2, 'priority' => 12);
               }
            if ($custom_tab_options['content3'] != '') {
               $tabs[] = array('title' => 'Otros', 'callback' => custom_product_tab_panel_3, 'priority' => 13);
               }
            return $tabs;
            }
         }
      add_action('woocommerce_product_tabs', 'woocommerce_product_custom_tab', 11);
      function custom_product_tab_panel_1()
         {
            global $post;
            $content = get_post_meta($post->ID, 'custom_tab_content1', true);
            echo '<h2>Caracter&iacute;sticas</h2>' .$content; //nl2br($content)
         }
      function custom_product_tab_panel_2()
         {
            global $post;
            $content = get_post_meta($post->ID, 'custom_tab_content2', true);
            echo '<h2>Ventajas</h2>' .$content;
         }
      function custom_product_tab_panel_3()
         {
            global $post;
            $content = get_post_meta($post->ID, 'custom_tab_content3', true);
            echo '<h2>Otros</h2>' .$content;
         }
      add_action('woocommerce_product_tab_panels', 'woocommerce_product_custom_panel', 11);
?>